﻿//////////////////////////////////////////////
// Viewport.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT Viewport
	{
		public :
		
			// Destructor
			virtual ~Viewport () ;

			// Getters
			virtual float getWidth () const = 0 ;
			virtual float getHeight () const = 0 ;
			virtual float getMinDepth () const = 0 ;
			virtual float getMaxDepth () const = 0 ;
			virtual float getTopLeftX () const = 0 ;
			virtual float getTopLeftY () const = 0 ;
			virtual nkMemory::StringView getName () const ;
			virtual bool getDirtyViewport () const ;

			// Setters
			virtual void setWidth (float width) = 0 ;
			virtual void setHeight (float height) = 0 ;
			virtual void setMinDepth (float value) = 0 ;
			virtual void setMaxDepth (float value) = 0 ;
			virtual void setTopLeftX (float value) = 0 ;
			virtual void setTopLeftY (float value) = 0 ;
			virtual void setName (nkMemory::StringView name) ;
			virtual void setDirtyViewport (bool value) ;

		public :

			// Statics
			static nkMemory::UniquePtr<Viewport> create (System* system = nullptr) ;

		protected :

			// Functions
			// Constructor
			Viewport () noexcept ;

		protected :

			// Attributs
			nkMemory::String _name ;
			bool _dirtyViewport ;
	} ;
}